package gov.va.vinci.dart.db.impl;

import java.sql.Timestamp;

import javax.persistence.Query;

import gov.va.vinci.dart.biz.EventSummary;
import gov.va.vinci.dart.db.util.NativeQueryDAO;

class ActivityEventSummaryDAO extends NativeQueryDAO<EventSummary> {

	private int activityId;
	
	ActivityEventSummaryDAO(final int activityId) {
		this.activityId = activityId;
	}
	
	public String getQueryText() {
		return "select r.activityid,e.requestid,e.createdon,p.fullname,e.description,r.trackingnumber,r.amendment from [hib].[event] e"+
		" inner join [hib].[request] r on r.id=e.requestid"+
		" inner join [hib].[person] p on p.name=e.createdby"+
		" where r.activityid=?"+
		" order by e.requestid,e.id";
	}
	
	public void populateParameters(final Query q) {
		q.setParameter(1, activityId); 
	}

	public EventSummary buildResult(final Object obj) {
		EventSummary summary = new EventSummary();

		if (obj.getClass().isArray()) {
			Object[] two = (Object[]) obj;
			
			summary.setActivityId((Integer)two[0]);
			summary.setRequestId((Integer)two[1]);
			summary.setCreatedOn((Timestamp)two[2]);
			summary.setCreatedBy((String)two[3]);
			summary.setDescription((String)two[4]);
			summary.setRequestTrackingNumber((String)two[5]);
			summary.setAmendment((Boolean)two[6]);

			return summary;
		}
		else {
			throw new IllegalStateException("Cannot parse JDBC query result");
		}

	}
}
